from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''

    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token

INVESTOR_KEY = ''
INVESTOR_ANALYSIS_KEY = ''

base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = f"/investor_registry/investor/{INVESTOR_KEY}/investor_analysis/{INVESTOR_ANALYSIS_KEY}/registry_data"
method = "PUT"

body = {
    "invested_value": 0.00,
    "monthly_income": 0.00,
    "is_politically_exposed_person": True,
    "person_type": "legal_person",
    "investor_sub_type": "resident | non-resident | financial_institution | fund_class",
    "investor_category": "retail | qualified | professional" ,
    "email": "sample@gmail.com",
    "cetip_account_number": "12345678",
    "bank_accounts": [
        {
            "financial_institution_code": "000",
            "account_number": "00000000000000000000",
            "account_digit": "0",
            "account_branch": "0000",
            "main_account": True
        }
    ],
    "legal_person": {
        "activity_code": "11.11-1-11",
        "representatives": [
            {
                "name": "Sample Person",
                "document_number": "000.000.000-00",
                "email": "sample@email.com.br",
                "phone": {
                  "international_dial_code": "55",
                  "area_code": "11",
                  "number": "1234567890"
                },
                "representative_type": "president | partner | administrator | director | manager | attorney",
                "person_type": "natural_person",
                "natural_person": {
                    "mother_name": "Sample name",
                    "birthdate": "YYYY-MM-DD",
                },
                "address": {
                    "street": "Sample",
                    "number": "000",
                    "neighborhood": "Sample",
                    "city": "Sample",
                    "postal_code": "00000-000",
                    "uf": "SP",
                    "country": "BRA",
                    "complement": "sample",
                },
            }
        ],
    },
    "address": {
        "street": "Sample",
        "number": "000",
        "neighborhood": "Sample",
        "city": "Sample",
        "postal_code": "00000-000",
        "uf": "SP",
        "country": "BRA",
        "complement": "sample",
    },
}

encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.put(url=url, headers=headers, json=body)
print(resp.json())

